package mednt.dbconn;

import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class SDBResult {

	private final String[][] res;

	protected SDBResult(ResultSet rs) throws SQLException {
		ArrayList<String[]> elems = new ArrayList<String[]>();
		int cols = rs.getMetaData().getColumnCount();
		while (rs.next()) {
			String[] v = new String[cols];
			for (int i = 0; i < cols; i++) {
				//byte[] buf = rs.getBytes(1 + i);
				//v[i] = getStringFromBuffor(buf);
				String vv = rs.getString(1 + i);
				v[i] = vv == null ? "" : vv;

			}
			elems.add(v);
		}
		this.res = elems.toArray(new String[elems.size()][]);
	}

	private String getStringFromBuffor(byte[] buffor) {
		if (buffor != null)
			try {
				return "" + new String(buffor, "utf-8");
			} catch (UnsupportedEncodingException e) {
				throw new AssertionError("UTF-8 is unknown");
			}
		return "";
	}

	/**
	 * Prywatna metoda do wyciągania konkretnych pól z wyników query
	 * 
	 * @return zawartość pola w stringu
	 */
	private String field(int row, int col) {
		return this.res[row][col];
	}

	/**
	 * @return ilość wierszy wyniku query
	 */
	public int rows() {
		return this.res.length;
	}

	/**
	 * Metoda do wyciągania intów z wyników query.<br>
	 * Rzuca "ArrayIndexOutOfBoundsException" w przypadku przekroczenia ilości wierszy lub kolumn wyniku query
	 * 
	 * @return -1 w przypadku niepowodzenia parsowania (jeśli wynik istnieje, ale nie jest poprawnym intem)
	 * @throws ArrayIndexOutOfBoundsException
	 *             w przypadku przekroczenia ilości wierszy lub kolumn wyniku query
	 * 
	 */
	public int i(int row, int col) {
		String s = this.s(row, col);

		try {
			return Integer.parseInt(s);
		} catch (Exception e) {
			return -1;
		}
	}

	/**
	 * Metoda do wyciągania stringów z wyników query.<br>
	 * Rzuca "ArrayIndexOutOfBoundsException"
	 * 
	 * @throws ArrayIndexOutOfBoundsException
	 *             w przypadku przekroczenia ilości wierszy lub kolumn wyniku query
	 */

	public String s(int row, int col) {
		return this.field(row, col);
	}

}
