package mednt.preskryptor.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import javax.xml.bind.DatatypeConverter;

import mednt.dbgen.ApiCmd;
import mednt.dbgen.ApiData;
import mednt.dbgen.ApiFormat;
import mednt.dbgen.ApiSource;
import mednt.dbgen.CustomCmd;
import mednt.dbgen.CustomResult;
import mednt.dbgen.LogCmd;
import mednt.dbgen.LogDoctor;
import mednt.dbgen.LogDoctorFacility;
import mednt.dbgen.LogDoctors;
import mednt.dbgen.LogDosationNumber;
import mednt.dbgen.LogDrug;
import mednt.dbgen.LogFacilities;
import mednt.dbgen.LogFacility;
import mednt.dbgen.LogPatient;
import mednt.dbgen.LogSex;
import mednt.dbgen.LogVisit;
import mednt.dbgen.LogVisitDoctor;
import mednt.dbgen.LogVisitIcd10;
import mednt.dbgen.LogVisitIcd10s;
import mednt.dbgen.LogVisitPatient;
import mednt.dbgen.LogVisitRecipe;
import mednt.dbgen.LogVisitRecipeDrug;
import mednt.dbgen.LogVisitRecipeDrugRef;
import mednt.dbgen.LogVisitRecipeDrugs;
import mednt.dbgen.LogVisitRecipies;
import mednt.dbgen.LogVisits;
import mednt.dbgen.TokenData;
import mednt.dbgen.TokenResult;
import mednt.lib.Err;

public class HectonetExample {
	public static void main(String[] args) throws ClassNotFoundException {
		CustomResult res = RequestUtil.processRequest(CustomCmd.createTest(), null);
		CustomResult token = RequestUtil.processRequest(CustomCmd.createGetToken(TestConstValues.USER_ID), null);
		if (!token.isToken())
			throw HectonetExample.err("TOKEN EXPECTED");
		TokenResult t = token.asToken();
		if (!t.isToken())
			throw HectonetExample.err("TOKEN EXPECTED is not ok [" + t.toJSON() + "]");
		TokenData tt = t.asToken();
		String hash = tt.getToken() + "#hash#" + TestConstValues.USER_PASSWD;
		String auth = "token#" + tt.getId() + "#" + HectonetExample.md5(hash);
		ApiData drugs = RequestUtil.processDrugs(new ApiCmd(ApiSource.createAll(), ApiFormat.createJson()), auth);
		HectonetExample.importAll(auth);
	}

	private static void importAll(String auth) {
		HectonetExample.importFacilities(auth);
		HectonetExample.importDoctors(auth);
		HectonetExample.importVisits(auth);
	}

	private static void importDoctors(String auth) {
		LogDoctors doctors = new LogDoctors();
		doctors.Insert(new LogDoctor(1, LogDoctorFacility.createRefId(1)));
		CustomResult vr = RequestUtil.processRequest(CustomCmd.createLog(LogCmd.createDoctors(doctors)), auth);
		System.out.println("importDoctors => " + vr.toJSON());
	}

	private static void importFacilities(String auth) {
		LogFacilities facilities = new LogFacilities();
		facilities.Insert(new LogFacility(1, "02-844", "Warszawa"));
		CustomResult vr = RequestUtil.processRequest(CustomCmd.createLog(LogCmd.createFacilities(facilities)), auth);
		System.out.println("importFacilities => " + vr.toJSON());
	}

	private static void importVisits(String auth) {
		LogVisitRecipies recipies = new LogVisitRecipies();
		LogVisitRecipeDrugs drugs = new LogVisitRecipeDrugs();
		drugs.Insert(new LogVisitRecipeDrug(1, "2 op.", LogDosationNumber.createOther(), "recepta", "",
		        LogVisitRecipeDrugRef.createDrug(new LogDrug(1, "Roticox", "tabl. powl.", "120 mg", "28 szt.", "5909991313333"))));
		drugs.Insert(new LogVisitRecipeDrug(2, "3 op.", LogDosationNumber.createOther(), "recepta", "", LogVisitRecipeDrugRef.createRefId(49439489)));
		recipies.Insert(new LogVisitRecipe(1, "NFZ", "aktywna", drugs));
		LogVisitIcd10s icd10s = new LogVisitIcd10s();
		icd10s.Insert(new LogVisitIcd10(1, true, false, "I10"));
		LogVisits visits = new LogVisits();
		visits.Insert(new LogVisit(1, "2024-06-10", "aktywna", "POZ", LogVisitDoctor.createRefId(1),
		        LogVisitPatient.createPatient(new LogPatient(1, "1945-05", LogSex.createOther())), icd10s, recipies));
		CustomResult vr = RequestUtil.processRequest(CustomCmd.createLog(LogCmd.createVisits(visits)), auth);
		System.out.println("importVisits => " + vr.toJSON());
	}

	private static String md5(String t) {
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			md.update(t.getBytes());
			byte[] digest = md.digest();
			return DatatypeConverter.printHexBinary(digest).toLowerCase();
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
			return null;
		}
	}

	private static RuntimeException err(String msg) {
		throw Err.err(new RuntimeException(msg));
	}

}
