package mednt.preskryptor.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

import mednt.dbgen.ApiCmd;
import mednt.dbgen.ApiData;
import mednt.dbgen.CustomCmd;
import mednt.dbgen.CustomCmdRev;
import mednt.dbgen.CustomResult;

public class RequestUtil {

	public static CustomResult processRequest(CustomCmd cmd, String auth) {
		String result = RequestUtil.process(cmd, auth);
		if (result == null)
			return null;
		return CustomResult.fromJSON(result);
	}

	private static String process(CustomCmd cmd, String auth) {
		try {
			long t0 = System.currentTimeMillis();
			URL url = new URL(TestConstValues.API_URL);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			if (auth != null)
				conn.setRequestProperty("Cookie", "auth=" + auth);
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			conn.setRequestProperty("charset", "utf-8");

			conn.setDoOutput(true);
			conn.getOutputStream().write(RequestUtil.mkBody(cmd));

			int code = conn.getResponseCode();
			if (code == HttpURLConnection.HTTP_OK) {
				InputStream is = conn.getInputStream();
				ByteArrayOutputStream result = new ByteArrayOutputStream();
				byte[] buffer = new byte[65536];
				for (;;) {
					int err = is.read(buffer);
					if (err <= 0)
						break;
					result.write(buffer, 0, err);
				}
				String response = new String(result.toByteArray(), StandardCharsets.UTF_8);
				conn.disconnect();
				long t = System.currentTimeMillis() - t0;
				System.out.println("Request time = " + (t / 1000.0) + "s");
				return response;
			} else {
				throw new IOException("Server returned non-OK status: " + code);
			}
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}

	private static byte[] mkBody(CustomCmd cmd) throws UnsupportedEncodingException {
		String json = new CustomCmdRev("2.0", cmd).toJSON();
		String url = "cmd=" + URLEncoder.encode(json, "UTF-8");
		return url.getBytes(StandardCharsets.UTF_8);
	}

	public static ApiData processDrugs(ApiCmd cmd, String auth) {
		String result = RequestUtil.process(CustomCmd.createApi(cmd), auth);
		if (result == null)
			return null;
		System.out.println("mam response >>" + result.substring(0, 100) + "<<");
		return ApiData.fromJSON(result);
	}
}
