<?php

function post_cmd($url, $json_data, $auth = null) {
    $data = ['cmd' => $json_data];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_USERAGENT, 'YourCustomUserAgent/1.0');  // Replace with your desired User-Agent
    $cookies = [];
    if ($auth != null) {
        $cookies[] = "auth=$auth";  // Dodaj ciasteczko
    }
    $cookie_string = implode('; ', $cookies); 
    curl_setopt($ch, CURLOPT_COOKIE, $cookie_string);  
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ['text' => $response, 'code' => $http_code];
}

// to jest funkcja, ktora wysyła obiekt CustomCmdRev do API, w odpowiedzi zawsze otrzymujemy tekst, a kod odpowiedzi powinien wynosic 200
function sendCmdReceiveText($cmd, $auth = null) {
    global $API_URL;

    # Tworzymy obiekt CustomCmdRev, który posiada metodę toJSON
    $cmd_rev = new CustomCmdRev("2.0", $cmd);
 
    # Konwertujemy go na JSON
    $json_data = $cmd_rev->toJSON();
    
    # Używamy requests do wysłania danych na endpoint
    $url = $API_URL;
    $response = post_cmd($url, $json_data, $auth);
    
    if ($response['code'] == 200) {
        return $response['text'];
    } else {
        throw new Exception("API nie odpowiedziało oczekiwanym kodem 200, otrzymaliśmy w odpowiedzi kod ". $response["code"]);
    }
}

// odpowiedzi inne niz zapytania o bazę leków generują odpowiedzi CustomResult
function sendCmdReceiveCustomResult($cmd, $auth = null) {
    $rText = sendCmdReceiveText($cmd, $auth);
    return CustomResult::fromJSON($rText);
}

// odpytywanie o baze lekow, daje w odpowiedzi obiekt ApiResult
function sendCmdReceiveApiResult($cmd, $auth = null) {
    $rText = sendCmdReceiveText($cmd, $auth);
    return ApiData::fromJSON($rText);
}

# to jest pobranie tokenu
function getToken() {
    global $USER_ID;
    $result = sendCmdReceiveCustomResult(CustomCmd::createGetToken($USER_ID));
    if (!$result->isToken())
        throw new Exception("TOKEN RESULT EXPECTED is no ok [" . $result->toJSON() . "]");
    return $result->asToken();
}


# to jest zbudowanie zawartosci cookie auth
function getAuthTokenCookie() {
    global $USER_PASSWD;
    $t=getToken();
    if ($t->isBad())
        throw new Exception("Bad TOKEN!");
    if (!$t->isToken())
        throw new Exception("TOKEN EXPECTED is no ok [" . $t->toJSON() . "]");
    $tt = $t->asToken(); # TokenData
    
    $ttt = $tt->getToken();
    $_hash = $ttt . "#hash#" . $USER_PASSWD;
    $ttid = $tt->getId();
    $_auth = "token#" . $ttid . "#" . md5($_hash);
    return $_auth;
}


?>
