#!/usr/bin/php
<?php

include "preskryptor_api/include_all_files.php";
include "hectonet_example_TestConnValues.php";
include "hectonet-example-functions.php";


function importFacilities($auth) {
	$facilities = new LogFacilities();
	$facilities->Insert(new LogFacility(1, "02-844", "Warszawa"));
	$vr = sendCmdReceiveCustomResult(CustomCmd::createLog(LogCmd::createFacilities($facilities)), $auth);
	print("importFacilities => " . $vr->toJSON() . "\n");
}

function importDoctors($auth) {
	$doctors = new LogDoctors();
	$doctors->Insert(new LogDoctor(1, LogDoctorFacility::createRefId(1)));
	$vr = sendCmdReceiveCustomResult(CustomCmd::createLog(LogCmd::createDoctors($doctors)), $auth);
	print("importDoctors => " . $vr->toJSON() . "\n");
}

function importVisits($auth) {
	$recipies = new LogVisitRecipies();
	$drugs = new LogVisitRecipeDrugs();
	$drugs->Insert(new LogVisitRecipeDrug(1, "2 op.", LogDosationNumber::createOther(), "recepta", "",
	        LogVisitRecipeDrugRef::createDrug(new LogDrug(1, "Roticox", "tabl. powl.", "120 mg", "28 szt.", "5909991313333"))));
	$drugs->Insert(new LogVisitRecipeDrug(2, "3 op.", LogDosationNumber::createOther(), "recepta", "", LogVisitRecipeDrugRef::createRefId(49439489)));
	$recipies->Insert(new LogVisitRecipe(1, "NFZ", "aktywna", $drugs));
	$icd10s = new LogVisitIcd10s();
	$icd10s->Insert(new LogVisitIcd10(1, True, False, "I10"));
	$visits = new LogVisits();
	$visits->Insert(new LogVisit(1, "2024-06-10", "aktywna", "POZ", LogVisitDoctor::createRefId(1),
	        LogVisitPatient::createPatient(new LogPatient(1, "1945-05", LogSex::createOther())), $icd10s, $recipies));
	$vr = sendCmdReceiveCustomResult(CustomCmd::createLog(LogCmd::createVisits($visits)), $auth);
	print("importVisits => " . $vr->toJSON() . "\n");
}

function importAll($auth) {
    importFacilities($auth);
    importDoctors($auth);
    importVisits($auth);
}

# sprawdzamy czy serwer dziala poprawnie
$rv=sendCmdReceiveCustomResult(CustomCmd::createTest());

$serverConnTest = $rv->isTest();
print('Sprawdzenie czy serwer dziala poprawnie: ' . $serverConnTest . "\n");
if ($serverConnTest == False)
    throw new Exception("Nie przyszła prawidłowa odpowiedź na zapytanie testowe.");

$_auth = getAuthTokenCookie();
importAll($_auth);

?>
