#!/usr/bin/python3
import requests
import json
import hashlib
import sys
from preskryptor_api import *

# z pliku 'hectonet_ezample_TextConnValues' wczytujemy parametry polaczenia i dane autoryzacyjne
import hectonet_example_TestConnValues as conf


# to jest funkcja, ktora wysyła obiekt CustomCmdRev do API, w odpowiedzi zawsze otrzymujemy tekst, a kod odpowiedzi powinien wynosic 200

def sendCmdReceiveText(cmd, auth = None):
    cmd_rev = CustomCmdRev("2.0", cmd)
    json_data = cmd_rev.toJSON()
    url = conf.API_URL
    cookies = { } 
    if (auth != None):
        cookies = { "auth": auth }
    response = requests.post(url, data={'cmd': json_data}, cookies=cookies)

    if response.status_code == 200:
        return response.text    
    raise Exception("API nie odpowiedziało oczekiwanym kodem 200, otrzymaliśmy w odpowiedzi kod ". response.status_code);

# odpowiedzi inne niz zapytania o bazę leków generują odpowiedzi CustomResult

def sendCmdReceiveCustomResult(cmd, auth = None):
    rText = sendCmdReceiveText(cmd, auth)
    return CustomResult.fromJSON(rText)

# odpytywanie o baze lekow, daje w odpowiedzi obiekt ApiResult
def sendCmdReceiveApiResult(cmd, auth = None):
    rText = sendCmdReceiveText(cmd, auth)
    return ApiData.fromJSON(rText)

# to jest pobranie tokenu
def getToken():
    result = sendCmdReceiveCustomResult(CustomCmd.createGetToken(conf.USER_ID));
    if (not result.isToken()):
        raise Exception("TOKEN RESULT EXPECTED is no ok [", result.toJSON(), "]")
    return result.asToken();


# to jest zbudowanie zawartosci cookie auth
def getAuthTokenCookie():
    t=getToken()
    if (t.isBad()):
        raise Exception("Bad TOKEN!")
    if (not t.isToken()):
        raise Exception("TOKEN EXPECTED is no ok [", t.toJSON(), "]")
    tt = t.asToken(); # TokenData
    _hash = tt.getToken() + "#hash#" + conf.USER_PASSWD;
    _auth = "token#" + str(tt.getId()) + "#" + hashlib.md5(_hash.encode()).hexdigest()
    return _auth;


def getDrugs(auth):
    result = sendCmdReceiveApiResult(CustomCmd.createApi(ApiCmd(ApiSource.createAll(), ApiFormat.createJson())), auth)
    return result 



# sprawdzamy czy serwer dziala poprawnie
rv=sendCmdReceiveCustomResult(CustomCmd.createTest())
serverConnTest = rv.isTest();
print('Sprawdzenie czy serwer dziala poprawnie: ', serverConnTest)
if serverConnTest == False:
    raise Exception("Nie przyszła prawidłowa odpowiedź na zapytanie testowe.")

_auth = getAuthTokenCookie()
drugs = getDrugs(_auth)

if drugs.isAll():
    allDrugs = drugs.asAll();
    print("pobrano " , allDrugs.getVersions().Size(), " produktów")
else:
    print("Nieoczekiwana odpowiedz.");


