#!/usr/bin/python3
import requests
import json
import hashlib
import sys
from preskryptor_api import *

# z pliku 'hectonet_ezample_TextConnValues' wczytujemy parametry polaczenia i dane autoryzacyjne
import hectonet_example_TestConnValues as conf


# to jest funkcja, ktora wysyła obiekt CustomCmdRev do API, w odpowiedzi zawsze otrzymujemy tekst, a kod odpowiedzi powinien wynosic 200

def sendCmdReceiveText(cmd, auth = None):
    cmd_rev = CustomCmdRev("2.0", cmd)
    json_data = cmd_rev.toJSON()
    url = conf.API_URL
    cookies = { } 
    if (auth != None):
        cookies = { "auth": auth }
    response = requests.post(url, data={'cmd': json_data}, cookies=cookies)

    print("na url>", url, "< wysylam >", json_data, "< z auth >", auth, "<")

    if response.status_code == 200:
        return response.text    
    raise Exception("API nie odpowiedziało oczekiwanym kodem 200, otrzymaliśmy w odpowiedzi kod ". response.status_code);

# odpowiedzi inne niz zapytania o bazę leków generują odpowiedzi CustomResult

def sendCmdReceiveCustomResult(cmd, auth = None):
    rText = sendCmdReceiveText(cmd, auth)
    print("w odpowiedzi mam >>", rText, "<<")
    return CustomResult.fromJSON(rText)

# odpytywanie o baze lekow, daje w odpowiedzi obiekt ApiResult
def sendCmdReceiveApiResult(cmd, auth = None):
    rText = sendCmdReceiveText(cmd, auth)
    return ApiResult.fromJSON(rText)

# to jest pobranie tokenu
def getToken():
    result = sendCmdReceiveCustomResult(CustomCmd.createGetToken(conf.USER_ID));
    if (not result.isToken()):
        raise Exception("TOKEN RESULT EXPECTED is no ok [", result.toJSON(), "]")
    return result.asToken();


# to jest zbudowanie zawartosci cookie auth
def getAuthTokenCookie():
    t=getToken()
    if (t.isBad()):
        raise Exception("Bad TOKEN!")
    if (not t.isToken()):
        raise Exception("TOKEN EXPECTED is no ok [", t.toJSON(), "]")
    tt = t.asToken(); # TokenData
    _hash = tt.getToken() + "#hash#" + conf.USER_PASSWD;
    _auth = "token#" + str(tt.getId()) + "#" + hashlib.md5(_hash.encode()).hexdigest()
    print (_hash)
    print (_auth)
    return _auth;


def getDrugs(auth):
    result = sendCmdReceiveApiResult(CustomCmd.createApi(ApiCmd(ApiSource.createAll(), ApiFormat.createJson())), auth)
    return result 

def importFacilities(auth):
	facilities = LogFacilities()
	facilities.Insert(LogFacility(1, "02-844", "Warszawa"))
	vr = sendCmdReceiveCustomResult(CustomCmd.createLog(LogCmd.createFacilities(facilities)), auth);
	print("importFacilities => " + vr.toJSON());

def importDoctors(auth):
	doctors = LogDoctors()
	doctors.Insert(LogDoctor(1, LogDoctorFacility.createRefId(1)))
	vr = sendCmdReceiveCustomResult(CustomCmd.createLog(LogCmd.createDoctors(doctors)), auth);
	print("importDoctors => " + vr.toJSON());

def importVisits(auth):
	recipies = LogVisitRecipies()
	drugs = LogVisitRecipeDrugs()
	drugs.Insert(LogVisitRecipeDrug(1, "2 op.", LogDosationNumber.createOther(), "recepta", "",
	        LogVisitRecipeDrugRef.createDrug(LogDrug(1, "Roticox", "tabl. powl.", "120 mg", "28 szt.", "5909991313333"))))
	drugs.Insert(LogVisitRecipeDrug(2, "3 op.", LogDosationNumber.createOther(), "recepta", "", LogVisitRecipeDrugRef.createRefId(49439489)))
	recipies.Insert(LogVisitRecipe(1, "NFZ", "aktywna", drugs))
	icd10s = LogVisitIcd10s()
	icd10s.Insert(LogVisitIcd10(1, True, False, "I10"))
	visits = LogVisits()
	visits.Insert(LogVisit(1, "2024-06-10", "aktywna", "POZ", LogVisitDoctor.createRefId(1),
	        LogVisitPatient.createPatient(LogPatient(1, "1945-05", LogSex.createOther())), icd10s, recipies))
	vr = sendCmdReceiveCustomResult(CustomCmd.createLog(LogCmd.createVisits(visits)), auth);
	print("importVisits => " + vr.toJSON());

def importAll(auth):
    importFacilities(auth)
#    importDoctors(auth)
#    importVisits(auth)

# sprawdzamy czy serwer dziala poprawnie
rv=sendCmdReceiveCustomResult(CustomCmd.createTest())
serverConnTest = rv.isTest();
print('Sprawdzenie czy serwer dziala poprawnie: ', serverConnTest)
if serverConnTest == False:
    raise Exception("Nie przyszła prawidłowa odpowiedź na zapytanie testowe.")

_auth = getAuthTokenCookie()



importAll(_auth)


