#!/usr/bin/python3
import requests
import json
from preskryptor_api import *

# Funkcja generująca JSON i wysyłająca zapytanie
def send_custom_command():
    # Tworzymy obiekt CustomCmd
    cmd = CustomCmd.createTest()

    # Tworzymy obiekt CustomCmdRev, który posiada metodę toJSON
    cmd_rev = CustomCmdRev("2.0", cmd)

    # Konwertujemy go na JSON
    json_data = cmd_rev.toJSON()

    # Sprawdzamy, czy JSON wygląda poprawnie
    print(f"Generated JSON: {json_data}")

    # Używamy requests do wysłania danych na endpoint
    url = "https://api.preskryptor.pl/cmd"
    response = requests.post(url, data={'cmd': json_data})

    # Sprawdzamy odpowiedź i ją wypisujemy
    print(f"Response Status Code: {response.status_code}")
    print(f"Response Text: {response.text}")

send_custom_command()

