/*
 * Decompiled with CFR 0.152.
 */
package mednt.preskryptor.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import mednt.dbgen.CodeGenLog;
import mednt.lib.Err;
import mednt.preskryptor.util.UtilReqValidator;

public class HectonetReqValidator {
    public static void main(String[] args) {
        System.out.println("Program do sprawdzania poprawno\u015bci zapyta\u0107\u00a0do Hectonet API, wersja 1.0.");
        if (args.length != 1 && args.length != 2) {
            HectonetReqValidator.printHelp();
            return;
        }
        int fileNameParam = 0;
        if (args.length == 1 && args[0].equals("-v")) {
            HectonetReqValidator.printHelp();
            return;
        }
        if (args.length == 2) {
            if (args[1].equals("-v")) {
                CodeGenLog.setVerbose(true);
                fileNameParam = 0;
            } else if (args[0].equals("-v")) {
                CodeGenLog.setVerbose(true);
                fileNameParam = 1;
            }
        }
        String filename = args[fileNameParam];
        try {
            String reqContent = new String(Files.readAllBytes(Paths.get(filename, new String[0])), "UTF-8");
            String rv = UtilReqValidator.validateJsonString(reqContent);
            if (rv.equals("")) {
                System.out.println("Zapytanie poprawne.");
                System.exit(0);
            } else {
                System.out.println(rv);
                System.exit(1);
            }
        }
        catch (IOException e) {
            System.out.println("B\u0142\u0105d podczas odczytu pliku: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Wymagany argument: plik tekstowy z tre\u015bci\u0105\u00a0zapytania, kt\u00f3re zostanie wys\u0142ane.");
        System.out.println("   cd ./bin");
        System.out.println("   java mednt.preskryptor.util.HectonetReqValidator  ../zapytania-bledne/sample-json1.txt");
        System.out.println("");
        System.out.println("Na ekranie zostanie wypisany komunikat o poprawnym sparsowaniu tre\u015bci pliku lub przebieg pasowania i prawdopodobona przyczyna b\u0142\u0119du");
    }

    private static RuntimeException err(String msg) {
        throw Err.err(new RuntimeException(msg));
    }
}

